<?php

/**
 * @version		$Id: helper.php 7 2011-07-21 14:25:18Z branko $
 * @author              Branko Wilhelm, mediahof, Kiel-Germany
 * @package		mod_simple_marquee
 * @copyright           Copyright (C) 2011 mediahof. All rights reserved.
 * @license		http://www.gnu.org/licenses/gpl.html GNU/GPL version 3
 */
// no direct access
defined('_JEXEC') or die;

class modSimpleMarquee {

    private static $load = null;

    public static function onload() {
        $document = & JFactory::getDocument();

        if (JFactory::getApplication()->isAdmin() || self::$load) {
            return false;
        }

        $document->addScript(JURI::base(true) . '/modules/mod_mh_simple_marquee/tmpl/mooquee.js');

        $css[] = 'div.mooquee-text{position:absolute;}';
        $css[] = 'div.mod_simple_marquee_content{overflow:hidden;white-space:nowrap;position:relative;}';
        $document->addStyleDeclaration(implode("\n", $css));

        $script = array(
            'window.addEvent("domready", function() {',
            '   var options = {};',
            '   $$("div.mod_simple_marquee").each(function(item) {',
            '       options["marWidth"] = item.getParent("div").getSize().x;',
            '       options["marHeight"] = item.getParent("div").getSize().y;',
            '       var config = item.getChildren()[0].getProperty("rel").split("|");',
            '       config.each(function(cfg) {',
            '           var tmp = cfg.split("=");',
            '           options[tmp[0]] = tmp[1];',
            '       });',
            '       new mooquee(item.getChildren()[1], options);',
            '   });',
            '});'
        );

        $document->addScriptDeclaration(implode("\n", $script));

        self::$load = true;
    }

}